IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT') 
BEGIN
	CREATE TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_NF] [int] NOT NULL,
		[CD_PROD] [int] NOT NULL,
		[CD_CTR] [int] NOT NULL,
	 CONSTRAINT [PK_EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_NF] ASC,
		[CD_PROD] ASC,
		[CD_CTR] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 80) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT_EST_NF_ENT_IT] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF], [CD_PROD])
	REFERENCES [dbo].[EST_NF_ENT_IT] ([CD_EMP], [CD_FILIAL], [CD_NF], [CD_PROD])

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT] CHECK CONSTRAINT [FK_EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT_EST_NF_ENT_IT]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT_EST_PROD_TRILHO_EXCESSO_ITENS] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_CTR], [CD_PROD])
	REFERENCES [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS] ([CD_EMP], [CD_FILIAL], [CD_CTR], [CD_PROD])

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT] CHECK CONSTRAINT [FK_EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT_EST_PROD_TRILHO_EXCESSO_ITENS]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT_CD_NF]  DEFAULT ((0)) FOR [CD_NF]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT_CD_CTR]  DEFAULT ((0)) FOR [CD_CTR]
END